 ; Ŀ
 ;   EzLay - show each layer sequentially, manipulate layers.              
 ;   Copyright 1994, 1997, 1998, 1999, 2005 by Rocket Software Ltd.        
 ;   Useful when you find seven times too many layers in a drawing.        
 ;                                                                         
 ;   Subcommands:                                                          
 ;   Any layer name = go to that layer, so 0 returns to the start.         
 ;   B freeze all But the current layer                                    
 ;   C Colour all entities on the current layer bylayer                    
 ;   D Delete the current layer                                            
 ;   E go to the layer of a picked Entity                                  
 ;   F Freeze the current layer                                            
 ;   G make the contents of the current layer Go to the marked one         
 ;   I Linetype all entities on the current layer bylayer                  
 ;   J show the text to William Blake's Jerusalem                          
 ;   L Explicitly linetype entities to the linetype of the current layer   
 ;   M Mark the current layer                                              
 ;   O Explicitly colour entities to the layer colour                      
 ;   P go to the Previous layer                                            
 ;   Q Quit (also Ctrl-C, or Esc in R13+)                                  
 ;   R Redisplay the current layer                                         
 ;   S Suck the contents of the marked layer onto the current one          
 ;   T Thaw the current layer                                              
 ;   X mark (with an x) the insertion of everything on the current layer.  
 ;                                                                         
 ; Ĵ
 ;   Subroutines:                                                          
 ;   Gonext: returns the name of the next layer in the tables.             
 ;   Oblot: undraw/draw a selection set.                                   
 ;   Redisp: redisplay all entities on a layer.                            
 ;   Perv: returns the name of the layer before the argument one.          
 ;   Ressto: redraw the selection set of undrawn entities, ss0.            
 ; 

 ; Ŀ
 ;   Gonext: steps through the layer tables, returns the name of the next  
 ;   layer or (if there is no next one) starts again, returning 0.         
 ;   Does not actually change the current layer.                           
 ; 
 (DEFUN GONEXT (/ rewind next llay)
  (if (setq next (tblnext "LAYER"))
      (setq llay (cdr (assoc 2 next)))
      (setq llay (cdr (assoc 2 (tblnext "LAYER" t)))))
 llay)
 ; Ŀ
 ;   Gonext end.                                                           
 ; 

 ; Ŀ
 ;    Oblot - undraw/draw a selection set.                                 
 ;    Takes two arguments: ss, the selection set,                          
 ;                         draw, the draw/undraw flag, t/nil respectively  
 ;    Returns an updated selection set of everything that is turned off.   
 ; 
 (DEFUN OBLOT (ss draw / num enam)
  (if (null ss0) (setq ss0 (ssadd)))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (redraw enam (if draw 1 2))
         (if draw
             (ssdel enam ss0)
             (ssadd enam ss0))
         (setq num (1+ num)))
 ss0)
 ; Ŀ
 ;    Oblot end.                                                           
 ; 

 ; Ŀ
 ;   Redisp: redisplay all entities on a layer.                            
 ;   Arguments: Prelay, the name of the previous displayed layer,          
 ;              Llay, the name of the layer to display,                    
 ;              Level, the index of the lowest screen menu box.            
 ;   Returns a list: the number of entities on the layer and an ss.        
 ; 
 (DEFUN REDISP (prelay llay level / ss len)
 ; Ŀ
 ;   Turn off everything on the layer Prelay (if Prelay contains a name).  
 ; 
  (if (and prelay (setq ss (ssget "X" (list (cons 8 prelay)))))
      (oblot ss ()))
 ; Ŀ
 ;   Display all entities on the new layer.                                
 ; 
  (if (setq ss (ssget "X" (list (cons 8 llay))))
      (progn
           (grtext level llay)
           (setq len (sslength ss))
           (oblot ss t))
      (progn
           (prompt (strcat "\nNo entities on " llay "."))
           (setq len 0)))
  (setvar "modemacro" (strcat llay ": " (itoa len) " entities."))
 (list len ss))
 ; Ŀ
 ;   Redisp end.                                                           
 ; 

 ; Ŀ
 ;   Perv - returns the name of the layer before the one passed as its     
 ;   sole argument.                                                        
 ; 
 (DEFUN PERV (llay / rew lay1 laylst len pos prev)
  (setq rew t)
  (while (setq lay1 (cdr (assoc 2 (tblnext "layer" rew))))
         (setq rew ())
         (if (null (wcmatch lay1 "*|*"))
             (setq laylst (append laylst (list lay1)))))
  (setq len (length laylst))
  (if (= llay "0")
      (setq pos (1- len))
      (setq pos (1- (- len (length (member llay laylst))))))
  (while (and (>= pos 0)
              (null (ssget "X" (list (cons 8 (setq prev (nth pos laylst)))))))
         (setq pos (1- pos)))
 prev)
 ; Ŀ
 ;   Perv end.                                                             
 ; 


 ; Ŀ
 ;    Ressto - redraw the selection set of undrawn entities, ss0.          
 ; 
 (DEFUN RESSTO (/ num enam)
  (setq num 0)
  (while (setq enam (ssname ss0 num))
         (redraw enam 1)
         (setq num (1+ num)))
  (setq ss0 ())
 (princ))
 ; Ŀ
 ;    Ressto end.                                                          
 ; 

 ; Ŀ
 ;   J - the undocumented religious history lesson.                        
 ; 
 (DEFUN J (/ jer jr2)
  (setq jer (strcat "        Jerusalem - verse 1"
                    "\n\nAnd did those feet, in ancient times,   "
                    "\nWalk upon England's mountains green,"
                    "\nAnd was the holy lamb of God,"
                    "\nIn England's pleasant pastures seen?"
                    "\nAnd did Thy countenance divine,"
                    "\nShine forth upon these crowded hills?"
                    "\nAnd was Jerusalem builded here,"
                    "\nAmong those dark satanic mills?"))
  (setq jr2 (strcat "        Jerusalem - verse 2"
                    "\n\nBring me my bow of burning gold,"
                    "\nBring me my arrows of desire,"
                    "\nBring me my spear, oh clouds unfold,"
                    "\nBring me my chariot of fire,"
                    "\nI will not sleep from mental fight,"
                    "\nNor shall my sword sleep in my hand,"
                    "\nTill we have built Jerusalem,"
                    "\nIn England's green and pleasant land.   "
                    "\n\n     William Blake\n"))
  (alert jer)
  (alert jr2))
 ; Ŀ
 ;   Jend.                                                                 
 ; 

 ; Ŀ
 ;   EzLay.                                                                
 ; 
 (DEFUN C:EZLAY (/ *error* esav level goon len frz promp what rad num enam pa
                           redsp prelay sslst gonxt prev next ssf insp finlay)
  (setvar "cmdecho" 0)
  (setq modem (getvar "modemacro"))
  (setq level (1- (getvar "screenboxes")))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk /)
   (ressto)
   (setvar "modemacro" modem)
  (princ))
 ; Ŀ
 ;   *Error* end.                                                          
 ; 
  (setq goon t)
 ; Ŀ
 ;   First obliterate everything and save the selection set thereof.       
 ; 
  (if (setq ss0 (ssget "X"))
      (oblot ss0 ()))
 ; Ŀ
 ;   Now see if there is a saved layer name.                               
 ; 
  (if (or (/= (type llay) 'STR)
          (null (tblsearch "layer" llay)))
      (setq llay (cdr (assoc 2 (tblnext "LAYER" t)))))
  (setq sslst (redisp prelay llay level)) ; redisplay new current layer
  (setq len (car sslst))                  ; number of entities on layer
  (setq ss (cadr sslst))                  ; ss thereof
  (while goon
 ; Ŀ
 ;   Go to the next layer and update the display if required, depending    
 ;   on values of the flags Gonxt and Redsp.                               
 ; 
         (cond ((and gonxt redsp)                ; go to next layer and redisp
                (setq prelay llay)               ; save current layer name
                (setq llay (gonext))             ; go to next
                (if (= llay "0") (setq goon ())) ; end if back at beginning
                (setq sslst (redisp prelay llay level)) ; display new layer
                (setq len (car sslst))           ; number of entities on layer
                (setq ss (cadr sslst)))          ; ss thereof
               (redsp
                (setq sslst (redisp prelay llay level)) ; redisplay layer
                (setq len (car sslst))           ; number of entities on layer
                (setq ss (cadr sslst))))         ; ss thereof
 ; Ŀ
 ;   See if the current layer is frozen.                                   
 ; 
         (setq frz (cdr (assoc 70 (tblsearch "layer" llay))))
         (if (= 1 (logand frz 1))
             (setq frz t)
             (setq frz ()))
 ; Ŀ
 ;   Make sure there are a current ss and length string, which there       
 ;   won't be if this is the first pass.                                   
 ; 
         (if (or (null ss) (null len))
             (progn
                  (if (setq ss (ssget "X" (list (cons 8 llay))))
                      (setq len (sslength ss))
                      (setq len 0))))
 ; Ŀ
 ;   Make the prompt string.                                               
 ; 
         (setq promp (strcat "\n" llay ": " (itoa len)
                             " ent" (if (= len 1) "" "s") ". "
                             "X/Del/Re/"
                             (if mark_ (strcat "Mark<" mark_ ">/Go/Suck")
                                       "Mark")
                             (if frz "/Thaw" "/Frz")
                             "/Cola/ilt/excO/exLt"
                             "/But/Ent/Prev/Quit/<Next>: "))
 ; Ŀ
 ;   If there are any entities on the current layer, ask the user what to  
 ;   do next.                                                              
 ; 
         (if (and goon (> len 0))
             (setq what (strcase (getstring promp)))
             (setq what "")) ; default cond will set gonxt and redisp to T
 ; Ŀ
 ;   Cond: decipher what the operator said.                                
 ; 
         (cond
 ; Ŀ
 ;   Put a marker X on everything on the layer.                            
 ; 
               ((= what "X" )
                (setq rad (/ (getvar "viewsize") 25))
                (setq lenstr (strcat "/" (itoa (sslength ss))))
                (setq num 0)
                (while (setq enam (ssname ss num))
                       (setq num (1+ num))
                       (grtext -2 (strcat (itoa num) lenstr))
                       (setq pa (cdr (assoc 10 (entget enam))))
                       (grdraw (polar pa (/ pi 4) rad)
                               (polar pa (* 1.25 pi) rad) 7)
                       (grdraw (polar pa (* pi 0.75) rad)
                       (polar pa (* pi 1.75) rad) 7))
                (setq redsp ())
                (setq gonxt ()))
 ; Ŀ
 ;   Freeze current layer.                                                 
 ; 
               ((= what "F")
 ; Ŀ
 ;   If the current layer is the same as the current displayed layer then  
 ;   it can't be frozen, so go to the next layer, make it current, freeze  
 ;   the current one, and redisplay the next.  If there is no next layer,  
 ;   set the current to 0.                                                 
 ; 
                (if (= llay (getvar "clayer"))
                    (progn
                         (setq prev llay)
                         (if (setq next (tblnext "LAYER"))
                             (setq llay (cdr (assoc 2 next)))
                             (setq llay "0"))
                         (command "layer" "s" llay "")
                         (command "layer" "freeze" prev ""))
                    (command "layer" "freeze" llay ""))
                (setq redsp t)
                (setq gonxt t))
 ; Ŀ
 ;   Thaw current layer and redisplay.                                     
 ; 
              ((= what "T")
               (command "layer" "thaw" llay "")
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   Freeze all but current layer.                                         
 ; 
              ((= what "B")
               (command "layer" "s" llay "freeze" "*" "")
               (setq redsp t)
               (setq gonxt t))
 ; Ŀ
 ;   Mark current layer.                                                   
 ; 
              ((= what "M")
               (setq mark_ llay)
               (setq redsp ())
               (setq gonxt ()))
 ; Ŀ
 ;   Make current layer Go to marked layer.                                
 ; 
              ((= what "G")
               (command ".change" ss "" "p" "layer" mark_ "")
 ; Ŀ
 ;   Changing the ss will redisplay it, so need to undisplay it again and  
 ;   add it to the undisplayed list.                                       
 ; 
               (oblot ss nil)
               (setq redsp t)
               (setq gonxt t))
 ; Ŀ
 ;   Suck marked onto current layer, redisplay current layer.              
 ; 
              ((= what "S")
               (setq ssf (ssget "X" (list (cons 8 mark_))))
               (command ".change" ssf "" "p" "layer" llay "")
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   Redisplay current layer.                                              
 ; 
              ((= what "R")
               (redraw)
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   Delete current layer.                                                 
 ; 
              ((= what "D")
               (initget 0 "Yes No")
               (Setq insp (getkword (strcat "Erase " llay " <Y>?")))
               (if (or (null insp) (= insp "Yes"))
                   (if ss (command "erase" ss "")))
               (setq redsp t)
               (setq gonxt t))
 ; Ŀ
 ;   Go to layer by entity selection.                                      
 ; 
              ((= what "E")
               (ressto)
               (setq finlay ())
               (while (null finlay)
                      (setq finlay (entsel "Select entity: ")))
               (setq llay (cdr (assoc 8 (entget (car finlay)))))
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   Go to the previous layer.                                             
 ; 
              ((= what "P")
               (setq prelay llay)
               (setq llay (perv llay))
               (tblsearch "layer" llay t)
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   Recolour all entities on the current layer bylayer.                   
 ; 
              ((= what "C")
               (command "change" ss "" "p" "colour" "bylayer" "")
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   Linetype all entities on the current layer bylayer.                   
 ; 
              ((= what "I")
               (command "change" ss "" "p" "ltype" "bylayer" "")
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   Explicitly linetype entities to match their layer.                    
 ; 
              ((= what "L")
               (setq lay (cdr (assoc 8 (entget (ssname ss 0)))))
               (setq laylt (cdr (assoc 6 (tblsearch "layer" lay))))
               (command "change" ss "" "p" "ltype" laylt "")
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   Explicitly colour entities to match their layer.                      
 ; 
              ((= what "O")
               (setq lay (cdr (assoc 8 (entget (ssname ss 0)))))
               (setq laycol (cdr (assoc 62 (tblsearch "layer" lay))))
               (command "change" ss "" "p" "colour" laycol "")
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   Quit -for the fainthearted who don't like Ctrl-C.                     
 ; 
              ((= what "Q")
               (*error* "")
               (setq goon ()))
 ; Ŀ
 ;   If the string wasn't a command, see if it was a layer name, if so     
 ;   put it into Llay and redisplay.                                       
 ; 
              ((and (= (type what) 'STR)
                    (tblsearch "layer" what t))
               (setq llay what)
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   J - the undocumented Jerusalem command.                               
 ; 
              ((= what "J")
               (j)
               (setq redsp t)
               (setq gonxt ()))
 ; Ŀ
 ;   <Return>: go to next layer.                                           
 ; 
              ((= what "")
               (setq redsp t)
               (setq gonxt t))
 ; Ŀ
 ;   Default - can't figure out what to do.  Print an error message and    
 ;   redisplay the current layer.                                          
 ; 
              ((/= what "")
               (write-line "No such layer or command.")
               (setq redsp ())
               (setq gonxt ()))))
  (ressto)                           ; if end of cycle, falls through cond
  (setvar "modemacro" modem)
 (princ))